/*
 * Decompiled with CFR 0.152.
 */
package TileMap;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Background {
    private BufferedImage image;
    private double x;
    private double y;
    private double dx;
    private double dy;
    private double moveScale;

    public Background(String s, double ms) {
        try {
            this.image = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.moveScale = ms;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPosition(double x, double y) {
        this.x = x * this.moveScale % 320.0;
        this.y = y * this.moveScale % 240.0;
    }

    public void setVector(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void update() {
        this.x += this.dx;
        this.y += this.dy;
    }

    public void draw(Graphics2D graphics) {
        graphics.drawImage((Image)this.image, (int)this.x, (int)this.y, null);
        if (this.x < 0.0) {
            graphics.drawImage((Image)this.image, (int)this.x + 320, (int)this.y, null);
        }
        if (this.x > 0.0) {
            graphics.drawImage((Image)this.image, (int)this.x - 320, (int)this.y, null);
        }
    }
}

